/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class BerserkPower
extends AbstractPower {
    public static final String POWER_ID = "Berserk";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Berserk");
    public static final String NAME = BerserkPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = BerserkPower.powerStrings.DESCRIPTIONS;

    public BerserkPower(String name, AbstractCreature owner, int amount) {
        this.name = name;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/thrillseeker.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0];
        for (int i = 0; i < this.amount; ++i) {
            this.description = this.description + "[R] ";
        }
        this.description = this.description + DESCRIPTIONS[1];
    }

    @Override
    public void atStartOfTurn() {
        if (this.owner.isPlayer && (float)this.owner.currentHealth <= (float)this.owner.maxHealth / 2.0f) {
            AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(this.amount));
            this.flash();
        }
    }
}

